package gov.va.genisis2.bo;

import static org.junit.Assert.assertNotNull;
import static org.mockito.Mockito.when;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

import gov.va.genisis2.AbstractMockMvcTests;
import gov.va.genisis2.converter.CommentHistoryConverter;
import gov.va.genisis2.converter.RequestConverter;
import gov.va.genisis2.converter.StudyApprovalConverter;
import gov.va.genisis2.converter.UserConverter;
import gov.va.genisis2.converter.UserRefreshHistoryConverter;
import gov.va.genisis2.dao.ICommentHistoryDao;
import gov.va.genisis2.dao.ILookUpDao;
import gov.va.genisis2.dao.IRequestDao;
import gov.va.genisis2.dao.IStudyApprovalDao;
import gov.va.genisis2.dao.IUserManagementDao;
import gov.va.genisis2.dto.CommentHistoryDTO;
import gov.va.genisis2.dto.RequestDTO;
import gov.va.genisis2.dto.StudyApprovalDTO;
import gov.va.genisis2.dto.UserCountDTO;
import gov.va.genisis2.exceptions.GenisisDAOException;
import gov.va.genisis2.exceptions.GenisisServiceException;
import gov.va.genisis2.model.CommentHistory;
import gov.va.genisis2.model.Request;
import gov.va.genisis2.model.RequestType;
import gov.va.genisis2.model.Source;
import gov.va.genisis2.model.StudyApproval;
import gov.va.genisis2.model.User;
import gov.va.genisis2.model.UserCount;
import gov.va.genisis2.model.UserRefreshHistory;
import gov.va.genisis2.service.impl.CommentHistoryService;
import gov.va.genisis2.service.impl.LookUpService;
import gov.va.genisis2.service.impl.RequestService;
import gov.va.genisis2.service.impl.StudyApprovalService;
import gov.va.genisis2.service.impl.UserManagementService;
import gov.va.genisis2.util.EhcacheHelper;
import gov.va.genisis2.util.rest.helper.ResponseWrapper;
import gov.va.genisis2.vo.CopyTableSource;

/**
 * @author Getaneh Kassahun
 *
 */
public class BusinessServiceTest extends AbstractMockMvcTests {

	/**
	 * The businessService.
	 */
	private BusinessService businessService;

	/**
	 * The studyApprovalService.
	 */
	private StudyApprovalService studyApprovalService;

	/**
	 * The userManagementService.
	 */
	private UserManagementService userManagementService;

	/**
	 * The lookUpService.
	 */
	private LookUpService lookUpService;

	/**
	 * The requestService.
	 */
	private RequestService requestService;

	/**
	 * The activiti service.
	 * 
	 */
	private ActivitiService activitiService;

	/**
	 * The commentHistoryService.
	 * 
	 */
	private CommentHistoryService commentHistoryService;

	/**
	 * The studyApprovalConverter.
	 */
	private StudyApprovalConverter studyApprovalConverter;

	/**
	 * The userConverter.
	 */
	private UserConverter userConverter;

	/**
	 * The businessHelper.
	 */
	private BusinessHelper businessHelper;

	/**
	 * The studyApproval.
	 */
	private StudyApproval studyApproval;

	/**
	 * The studyApproval.
	 */
	private StudyApprovalDTO studyApprovalDto;

	/**
	 * The userRefreshHistoryConverter.
	 */
	private UserRefreshHistoryConverter userRefreshHistoryConverter;

	/**
	 * The userRefreshHistoryConverter.
	 */
	private RequestConverter requestConverter;

	/**
	 * The userRefreshHistoryConverter.
	 */
	private CommentHistoryConverter commentHistoryConverter;

	/**
	 * The user.
	 */
	private User user;

	/**
	 * The request.
	 */
	private Request request;

	/**
	 * The commentHistory.
	 */
	private CommentHistory commentHistory;

	/**
	 * The requestDto.
	 */
	private RequestDTO requestDto;

	/**
	 * The commentHistoryDTO.
	 */
	private CommentHistoryDTO commentHistoryDTO;
	
	/**
	 * The workflowDeadendsList.
	 * 
	 */
	private List<String> workflowDeadendsList;

	/**
	 * The emailHelper.
	 * 
	 */
	private EmailHelper emailHelper;
	

	private EhcacheHelper ehcacheHelper;
	/**
	 * The studyApprovalDao.
	 */
	@Autowired
	private IStudyApprovalDao studyApprovalDao;

	/**
	 * The userManagementDao.
	 */
	@Autowired
	private IUserManagementDao userManagementDao;

	/**
	 * The requestDao.
	 */
	@Autowired
	private IRequestDao requestDao;

	/**
	 * The lookUpDao.
	 */
	@Autowired
	private ILookUpDao lookUpDao;

	/**
	 * The commentHistoryDao.
	 */
	@Autowired
	private ICommentHistoryDao commentHistoryDao;

	/**
	 * Run before all test methods.
	 */
	@Before
	public void setUp() {

		businessService = new BusinessService();
		studyApprovalService = getMockStudyApprovalService();
		userManagementService = getMockUserManagementService();
		lookUpService = getMockLookUpService();
		requestService = getMockRequestService();
		activitiService = getMockActivitiService();
		commentHistoryService = getMockCommentHistoryService();

		studyApprovalConverter = getMockStudyApprovalConverter();
		userConverter = getMockUserConverter();
		userRefreshHistoryConverter = getMockUserRefreshHistoryConverter();
		requestConverter = new RequestConverter();
		commentHistoryConverter = new CommentHistoryConverter();
		businessHelper = new BusinessHelper();
		emailHelper = new EmailHelper();
		ehcacheHelper = new EhcacheHelper();
		businessHelper.setWorkflowDeadendsList(getListOfworkflowDeadendsList());
		 

		userConverter.setUserApproverConverter(getMockUserApproverConverter());
		userConverter.setUserRoleTypeConverter(getMockUserRoleTypeConverter());
		requestConverter.setRequestTypeConverter(getMockRequestTypeConverter());
		requestConverter.setSourceConverter(getMockSourceConverter());
		requestConverter.setStudyApprovalConverter(getMockStudyApprovalConverter());

		studyApprovalService.setStudyApprovalDao(getMockStudyApprovalDao());
		userManagementService.setUserManagementDao(getMockUserManagementDao());
		lookUpService.setLookUpDao(getMockLookUpDao());
		requestService.setRequestDao(getMockRequestDao());
		commentHistoryService.setCommentHistoryDao(getMockCommentHistoryDao());

		businessService.setStudyApprovalConverter(studyApprovalConverter);
		businessService.setUserConverter(userConverter);
		businessService.setUserRefreshHistoryConverter(userRefreshHistoryConverter);
		businessService.setSourceConverter(getMockSourceConverter());
		businessService.setRequestTypeConverter(getMockRequestTypeConverter());
		businessService.setGenisisPropertiesUtil(getMockGenisisPropertiesUtil());
		businessService.setRequestConverter(requestConverter);
		businessService.setCommentHistoryConverter(commentHistoryConverter);

		businessService.setStudyApprovalService(studyApprovalService);
		businessService.setUserManagementService(userManagementService);
		businessService.setLookUpService(lookUpService);
		businessService.setRequestService(requestService);
		businessService.setActivitiService(activitiService);
		businessService.setCommentHistoryService(commentHistoryService);
		businessService.setBusinessHelper(businessHelper);
		businessService.setEmailHelper(emailHelper);
		businessService.setEhcacheHelper(ehcacheHelper);
	}

	/**
	 * To testCreateStudyApproval.
	 */
	@Test
	public void testCreateStudyApproval() throws GenisisServiceException, GenisisDAOException {

		StudyApprovalDTO studyApproval = studyApprovalConverter.convert(studyApprovalDao.getStudyApprovalsByID(176));
		when(getMockStudyApprovalService().createStudyApproval(studyApprovalDao.getStudyApprovalsByID(176)))
				.thenReturn(176);
		assertNotNull(businessService.createStudyApproval(studyApproval));
	}

	/**
	 * To testCreateStudyApproval.
	 */
	@Test
	public void testCreateStudyApproval_Null1() throws GenisisServiceException {

		when(getMockStudyApprovalService().createStudyApproval(null)).thenReturn(0);
		assertNotNull(businessService.createStudyApproval(null));
	}

	/**
	 * To testCreateStudyApproval.
	 */
	@Test
	public void testCreateStudyApproval_Null2() throws GenisisServiceException {

		when(getMockStudyApprovalService().createStudyApproval(new StudyApproval())).thenReturn(0);
		assertNotNull(businessService.createStudyApproval(new StudyApprovalDTO()));
	}

	/**
	 * To testGetStudyApprovalsByID.
	 * 
	 * @throws GenisisDAOException
	 */
	@Test
	public void testGetStudyApprovalsByID() throws GenisisServiceException, GenisisDAOException {

		StudyApproval StudyApproval = studyApprovalDao.getStudyApprovalsByID(176);
		when(getMockStudyApprovalService().getStudyApprovalsByID(176)).thenReturn(StudyApproval);
		assertNotNull(businessService.getStudyApprovalsByID(176));
	}

	/**
	 * To test getStudyApprovalsByUID.
	 * 
	 * @throws GenisisDAOException
	 */
	@Test
	public void testGetStudyApprovalsByUID() throws GenisisServiceException, GenisisDAOException {

		List<StudyApproval> StudyApprovals = studyApprovalDao.getStudyApprovalsByUID("createdBy");
		when(getMockStudyApprovalService().getStudyApprovalsByUID("createdBy")).thenReturn(StudyApprovals);
		assertNotNull(businessService.getStudyApprovalsByUID("createdBy"));
	}

	/**
	 * To test getStudyApprovals.
	 * 
	 * @throws GenisisDAOException
	 */
	@Test
	public void testGetStudyApprovals() throws GenisisServiceException, GenisisDAOException {

		List<StudyApproval> StudyApprovals = studyApprovalDao.getStudyApprovals();
		when(getMockStudyApprovalService().getStudyApprovals()).thenReturn(StudyApprovals);
		assertNotNull(businessService.getStudyApprovals());
	}

	/**
	 * To test getUserDetailsByUsername.
	 * 
	 * @throws GenisisDAOException
	 */
	@Test
	public void testGetUserDetailsByUsername() throws GenisisServiceException, GenisisDAOException {

		User user = userManagementDao.getUserDetailsByUsername("DNS   DNS");
		when(getMockUserManagementService().getUserDetailsByUsername("DNS   DNS")).thenReturn(user);
		assertNotNull(businessService.getUserDetailsByUsername("DNS   DNS"));
	}

	/**
	 * To test getUserCountsAndLdapLastRefresh.
	 * 
	 */
	@Test
	public void testGetUserCountsAndLdapLastRefresh() throws GenisisServiceException {

		List<UserCount> userCounts = getMockUserManagementService().getUserCountOnRole();
		Date lastRefreshed = getMockUserManagementService().getLatestUserRefreshHistory();
		when(getMockUserManagementService().getUserCountOnRole()).thenReturn(userCounts);
		when(getMockUserManagementService().getLatestUserRefreshHistory()).thenReturn(lastRefreshed);
		UserCountDTO userCountDTO = getMockUserCountConverter().populateUserCount(userCounts, lastRefreshed);
		when(getMockUserCountConverter().populateUserCount(userCounts, lastRefreshed)).thenReturn(userCountDTO);
		assertNotNull(businessService.getUserCountsAndLdapLastRefresh());
	}

	/**
	 * To test testRefreshUserData.
	 * 
	 */
	@Test
	public void testRefreshUserData() throws GenisisServiceException {

		when(getMockUserManagementService().createUserRefreshHistory(new UserRefreshHistory())).thenReturn(1);
	}

	/**
	 * To test getGenisisAPIDetails.
	 * 
	 */
	@Test
	public void testGetGenisisAPIDetails() throws GenisisServiceException {

		ResponseWrapper responseWrapper = new ResponseWrapper();
		when(getMockBusinessService().getGenisisAPIDetails()).thenReturn(responseWrapper);
		businessService.getClass();
		// assertNotNull(businessService.getGenisisAPIDetails());
	}

	/**
	 * To test updateStudyApproval.
	 * 
	 * @throws GenisisDAOException
	 * 
	 */
	@Test
	public void testUpdateStudyApproval() throws GenisisServiceException, GenisisDAOException {

		studyApprovalConverter = new StudyApprovalConverter();
		studyApproval = studyApprovalDao.getStudyApprovalsByID(177);
		studyApprovalDto = studyApprovalConverter.convert(studyApproval);
		when(getMockStudyApprovalService().updateStudyApproval(studyApproval)).thenReturn(176);
		assertNotNull(businessService.updateStudyApproval(studyApprovalDto));
	}

	/**
	 * To test updateStudyApproval.
	 * 
	 * 
	 */
	@Test
	public void testUpdateStudyApproval_Null() throws GenisisServiceException {

		when(getMockStudyApprovalService().updateStudyApproval(null)).thenReturn(0);
		assertNotNull(businessService.updateStudyApproval(null));
	}

	/**
	 * To test updateStudyApproval.
	 * 
	 * 
	 */
	@Test
	public void testUpdateStudyApproval_Id0() throws GenisisServiceException {

		when(getMockStudyApprovalService().updateStudyApproval(new StudyApproval())).thenReturn(0);
		assertNotNull(businessService.updateStudyApproval(new StudyApprovalDTO()));
	}

	/**
	 * To test getRequestDataSources.
	 * 
	 * 
	 */
	@Test
	public void testGetRequestDataSources() throws GenisisServiceException {

		List<Source> dataSource = getMockLookUpService().getDataSources();
		when(getMockLookUpService().getDataSources()).thenReturn(dataSource);
		assertNotNull(businessService.getRequestDataSources());
	}

	/**
	 * To test getRequestTypes.
	 * 
	 * 
	 */
	@Test
	public void testGetRequestTypes() throws GenisisServiceException {

		List<RequestType> listRequestTypes = getMockLookUpService().getRequestTypes();
		when(getMockLookUpService().getRequestTypes()).thenReturn(listRequestTypes);
		assertNotNull(businessService.getRequestTypes());
	}

	/**
	 * To test getUserDetailsByEmail.
	 * 
	 * 
	 */
	@Test
	public void testGetUserDetailsByEmail() throws GenisisServiceException {

		user = userManagementService.getUserDetailsByEmail("genisisad@gmail.com");
		when(getMockUserManagementService().getUserDetailsByEmail("genisisad@gmail.com")).thenReturn(user);
		assertNotNull(businessService.getUserDetailsByEmail("genisisad@gmail.com"));
	}

	/**
	 * To test getUserDetailsById.
	 * 
	 * 
	 */
	@Test
	public void testGetUserDetailsById() throws GenisisServiceException {

		user = userManagementService.getUserDetailsById(1);
		when(getMockUserManagementService().getUserDetailsById(1)).thenReturn(user);
		assertNotNull(businessService.getUserDetailsById(1));
	}

	/**
	 * To test getUserRole.
	 * 
	 * 
	 */
	@Test
	public void testGetUserRole() throws GenisisServiceException {

		String uid = userManagementService.getUserRole(1);
		when(getMockUserManagementService().getUserRole(1)).thenReturn(uid);
		assertNotNull(businessService.getUserRole(1));
	}

	/**
	 * To test createRequest.
	 * 
	 * @throws GenisisDAOException
	 * 
	 * 
	 */
	@Test
	public void testCreateRequest() throws GenisisServiceException, GenisisDAOException {

		String processInstanceId = "processInstanceId";
		request = requestDao.getRequestById(1);
		requestDto = requestConverter.convert(request);
		when(getMockRequestService().getRequestById(1)).thenReturn(request);
		when(getMockActivitiService().startProcess(request.getCreatedBy())).thenReturn(processInstanceId);
		assertNotNull(businessService.createRequest(requestDto));
	}

	/**
	 * To test createRequest.
	 * 
	 * @throws GenisisDAOException
	 * 
	 * 
	 */
	@Test
	public void testCreateRequest_ApproverIdNull() throws GenisisServiceException, GenisisDAOException {

		String processInstanceId = "processInstanceId";
		request = requestDao.getRequestById(1);
		requestDto = requestConverter.convert(request);
		requestDto.setApproverId(null);
		when(getMockRequestService().getRequestById(1)).thenReturn(request);
		when(getMockActivitiService().startProcess(request.getCreatedBy())).thenReturn(processInstanceId);
		assertNotNull(businessService.createRequest(requestDto));
	}

	/**
	 * To test getRequestByID.
	 * 
	 * @throws GenisisDAOException
	 * 
	 * 
	 */
	@Test
	public void testGetRequestByID() throws GenisisServiceException, GenisisDAOException {

		request = requestDao.getRequestById(1);
		when(getMockRequestService().getRequestById(1)).thenReturn(request);
		assertNotNull(businessService.getRequestByID(1));
	}

	/**
	 * To test getRequestTrackingByID.
	 * 
	 * @throws GenisisDAOException
	 * 
	 * 
	 */
	@Test
	public void testGetRequestTrackingByID() throws GenisisServiceException, GenisisDAOException {

		request = requestDao.getRequestById(1);
		when(getMockRequestService().getRequestById(1)).thenReturn(request);
		assertNotNull(businessService.getRequestTrackingByID(1, "Admin"));
	}

	/**
	 * To test getRequestsByUID.
	 * 
	 * 
	 * 
	 */
	@Test
	public void testGetRequestsByUID() throws GenisisServiceException {

		List<Request> requests = getMockRequestService().getRequestsByUID("datamanager4");
		when(getMockRequestService().getRequestsByUID("datamanager4")).thenReturn(requests);
		assertNotNull(businessService.getRequestsByUID("datamanager4"));
	}

	/**
	 * To test getRequestsByDataManagers.
	 * 
	 * 
	 * 
	 */
	@Test
	public void testGetRequestsByDataManagers() throws GenisisServiceException {

		List<Request> requests = getMockRequestService().getRequestsByDataManagers("datamanager4");
		when(getMockRequestService().getRequestsByDataManagers("datamanager4")).thenReturn(requests);
		assertNotNull(businessService.getRequestsByDataManagers("datamanager4"));
	}

	/**
	 * To test getRequestsDataSourceManagers.
	 * 
	 * 
	 * 
	 */
	@Test
	public void testGetRequestsDataSourceManagers() throws GenisisServiceException {

		List<Request> requests = getMockRequestService().getRequestsDataSourceManagers("datamanager4");
		when(getMockRequestService().getRequestsDataSourceManagers("datamanager4")).thenReturn(requests);
		assertNotNull(businessService.getRequestsDataSourceManagers("datamanager4"));
	}

	/**
	 * To test getAllRequests.
	 * 
	 * 
	 * 
	 */
	@Test
	public void testGetAllRequests() throws GenisisServiceException {

		List<Request> requests = getMockRequestService().getAllRequests();
		when(getMockRequestService().getAllRequests()).thenReturn(requests);
		assertNotNull(businessService.getAllRequests());
	}

	/**
	 * To test getAllRequestsByStudyApproval.
	 * 
	 * @throws GenisisDAOException
	 * 
	 * 
	 * 
	 */
	@Test
	public void testGetAllRequestsByStudyApproval() throws GenisisServiceException, GenisisDAOException {

		StudyApproval studayApproval = studyApprovalDao.getStudyApprovalsByID(176);
		int studyApprovalId = studayApproval.getId();
		List<Request> requests = getMockRequestService().getAllRequestsByStudyApproval(studyApprovalId);
		when(getMockRequestService().getAllRequestsByStudyApproval(studyApprovalId)).thenReturn(requests);
		assertNotNull(businessService.getAllRequestsByStudyApproval(studayApproval.getId()));
	}

	/**
	 * To test getAllRequestsByStaus.
	 * 
	 * @throws GenisisDAOException
	 * 
	 * 
	 * 
	 */
	@Test
	public void testGetAllRequestsByStaus() throws GenisisServiceException, GenisisDAOException {

		Source source = lookUpDao.getSource(1);
		List<Request> requests = getMockRequestService().getAllRequestsByStaus(source.getDescription());
		when(getMockRequestService().getAllRequestsByStaus(source.getDescription())).thenReturn(requests);
		assertNotNull(businessService.getAllRequestsByStaus(source.getDescription()));
	}

	/**
	 * To test submitOrModify.
	 * 
	 * @throws GenisisDAOException
	 * 
	 * 
	 * 
	 */
	@Test
	public void testSubmitOrModify() throws GenisisServiceException, GenisisDAOException {

		String processInstanceId = "processInstanceId";
		request = requestDao.getRequestById(1);
		requestDto = requestConverter.convert(request);
		when(getMockRequestService().getRequestById(1)).thenReturn(request);
		when(getMockActivitiService().startProcess(request.getCreatedBy())).thenReturn(processInstanceId);
		when(getMockRequestService().submitOrModify(request)).thenReturn(1);
		assertNotNull(businessService.submitOrModify(requestDto));
	}

	/**
	 * To test persist.
	 * 
	 * @throws GenisisDAOException
	 * 
	 * 
	 * 
	 */
	@Test
	@Ignore
	public void persist() throws GenisisServiceException, GenisisDAOException {

		request = requestDao.getRequestById(1);
		requestDto = requestConverter.convert(request);
		when(getMockRequestService().getRequestById(1)).thenReturn(request);
		assertNotNull(businessService.persist(1, requestDto, requestDto.getStatusDescription()));
	}

	/**
	 * To test CreateCommentHistory.
	 * 
	 * @throws GenisisDAOException
	 * 
	 * 
	 * 
	 */
	@Test
	public void testCreateCommentHistory() throws GenisisServiceException, GenisisDAOException {

		request = requestDao.getRequestById(1);
		commentHistory = commentHistoryDao.getCommentHistoryByCommentId(1);
		commentHistory.setRequest(request);
		commentHistory.setRequestId(request.getId());
		commentHistory.setCommentTypeId(1);
		commentHistoryDTO = commentHistoryConverter.convert(commentHistory);
		when(getMockRequestService().getRequestById(1)).thenReturn(request);
		when(getMockLookUpService().getStatusId(commentHistory.getStatus())).thenReturn(1);
		when(getMockCommentHistoryService().submitOrModify(commentHistory)).thenReturn(1);
		assertNotNull(businessService.createCommentHistory(commentHistoryDTO));
	}
	
	/**
	 * To test testPerformTableCopyTransfer.
	 * 
	 */
	@Test
	public void testPerformTableCopyTransfer() throws GenisisServiceException {

		ResponseWrapper wrapper = new ResponseWrapper();
		CopyTableSource copyTableSource = new CopyTableSource("tableNameTest", "tcSourceDataBaseServerNameTest",
				"tcSourceDataBaseNameTest", "sourceSchemaNameTest", "tcDestinationDataBaseServerNameTest",
				"tcDestinationDataBaseUserNameTest", "tcDestinationDataBaseUserPasswordTest",
				"tcDestinationServerDataBaseNameTest", "destinationSchemaNameTest",
				"tcManagementDataBaseServerNameTest", "tcManagementDataBaseUserNameTest",
				"tcManagementDataBaseUserPasswordTest", "tcManagementDataBaseSchemaTest", "cmdFilePathTest",
				"tcManagementDataBaseNameTest", "tcTemporaryDataBaseNameTest");
		 //assertNotNull(businessService.performTableCopyTransfer(copyTableSource, 1));
	}

	/**
	 * To test testGetCopyTableDomainDetails.
	 * 
	 */
	@Test
	public void testGetCopyTableDomainDetails() throws GenisisServiceException {

		assertNotNull(businessService.getCopyTableDomainDetails());
	}
	
	/**
	 * To getListOfworkflowDeadendsList.
	 * 
	 */
	private List<String> getListOfworkflowDeadendsList (){
		workflowDeadendsList = new ArrayList<String>();
		workflowDeadendsList.add("Denied");
		workflowDeadendsList.add("RequestNotAccepted");
		workflowDeadendsList.add("ResultsNotAccepted");
		workflowDeadendsList.add("Cancelled");
		
		return workflowDeadendsList;
		
	}

}
